﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
var sysreq = {
    opts: {
        updateLinkID: 'lnkUpdateBrowser',
        browserDDID: 'selBrowser',
        browsersURL: [
            null,
            'http://windows.microsoft.com/en-us/internet-explorer/download-ie',
            'http://www.google.com/chrome',
            'http://www.mozilla.org/en-US/firefox/new/',
            'http://www.apple.com/safari'
        ]
    },

    updateBrowser: function (obj) {
        var me = this,
            lnk = $('a[id$="' + me.opts.updateLinkID + '"]')[0],
            sel = obj;

        if (sel.selectedIndex < 1) {
            $(lnk).attr('href', '#').attr('onclick', 'return false;');
            return false;
        }
        else {
            var m_val = parseInt($(sel).val()),
                m_href = me.opts.browsersURL[m_val];
            $(lnk).attr('href', m_href).attr('onclick', 'return true;');
            return true;
        }
    }
};

//DETECT BROWSER
var BrowserDetect = {
    init: function () {
        this.browser = this.searchString(this.dataBrowser) || "An unknown browser";
        this.version = this.searchVersion(navigator.userAgent)
			|| this.searchVersion(navigator.appVersion)
			|| "an unknown version";
        this.OS = this.searchString(this.dataOS) || "an unknown OS";
    },
    searchString: function (data) {
        for (var i = 0; i < data.length; i++) {
            var dataString = data[i].string;
            var dataProp = data[i].prop;
            this.versionSearchString = data[i].versionSearch || data[i].identity;
            if (dataString) {
                if (dataString.indexOf(data[i].subString) != -1)
                    return data[i].identity;
            }
            else if (dataProp)
                return data[i].identity;
        }
    },
    searchVersion: function (dataString) {
        var index = dataString.indexOf(this.versionSearchString);
        if (index == -1) return;
        return parseFloat(dataString.substring(index + this.versionSearchString.length + 1));
    },
    dataBrowser: [
		{
		    string: navigator.userAgent,
		    subString: "Chrome",
		    identity: "Chrome"
		},
		{
		    string: navigator.userAgent,
		    subString: "OmniWeb",
		    versionSearch: "OmniWeb/",
		    identity: "OmniWeb"
		},
		{
		    string: navigator.vendor,
		    subString: "Apple",
		    identity: "Safari",
		    versionSearch: "Version"
		},
		{
		    prop: window.opera,
		    identity: "Opera",
		    versionSearch: "Version"
		},
		{
		    string: navigator.vendor,
		    subString: "iCab",
		    identity: "iCab"
		},
		{
		    string: navigator.vendor,
		    subString: "KDE",
		    identity: "Konqueror"
		},
		{
		    string: navigator.userAgent,
		    subString: "Firefox",
		    identity: "Firefox"
		},
		{
		    string: navigator.vendor,
		    subString: "Camino",
		    identity: "Camino"
		},
		{		// for newer Netscapes (6+)
		    string: navigator.userAgent,
		    subString: "Netscape",
		    identity: "Netscape"
		},
		{
		    string: navigator.userAgent,
		    subString: "MSIE",
		    identity: "Explorer",
		    versionSearch: "MSIE"
		},
		{
		    string: navigator.userAgent,
		    subString: "Gecko",
		    identity: "Mozilla",
		    versionSearch: "rv"
		},
		{ 		// for older Netscapes (4-)
		    string: navigator.userAgent,
		    subString: "Mozilla",
		    identity: "Netscape",
		    versionSearch: "Mozilla"
		}
    ],
    dataOS: [
		{
		    string: navigator.platform,
		    subString: "Win",
		    identity: "Windows"
		},
		{
		    string: navigator.platform,
		    subString: "Mac",
		    identity: "Mac"
		},
		{
		    string: navigator.userAgent,
		    subString: "iPhone",
		    identity: "iPhone/iPod"
		},
		{
		    string: navigator.platform,
		    subString: "Linux",
		    identity: "Linux"
		}
    ]

};
BrowserDetect.init();

String.prototype.format = function () {
    var args = arguments;
    return this.replace(/{(\d+)}/g, function (match, number) {
        return typeof args[number] != 'undefined'
      ? args[number]
      : match
        ;
    });
};

//functions that will be fired only when the DOM is ready

$(window).bind({
    resize: function () {
        if (typeof (soap) != "undefined") {
            if (typeof (soap.resizeTxtSOAP) != "undefined") {
                soap.resizeTxtSOAP();
            }
        }

        $('div[id$="divUsersList"]').css({ height: $('div[id$="div-page-contents"]').height() - 63 });

        /********************************************
        *    ADJUST AGGREGATE REPORTS SCREEN       *
        ********************************************/
        if (window.location.href.indexOf('aggregate_report.aspx') > -1) {
            if (typeof formatScreen != "undefined") {
                formatScreen();
            }
        }
    }
});

/*
 ----------------------------------------------------
    Relocated from Master Page
    -Used in Lookup popups-
 ----------------------------------------------------
*/
function OnGVLinkClick(id, colheader, propname, propval, rowid) {
    if (id == 'gvPatients') {
        __doPostBack("PATIENT_LOOKUP", rowid);
    } else if (id == 'gvUsers') {
        __doPostBack("USER_LOOKUP", rowid);
    } else if (id == 'gvPortalUsers') {
        __doPostBack("PORTAL_PATIENT_LOOKUP", rowid);
    } else if (id == 'gvReferralClinics') {
        __doPostBack("REFERRAL_CLINIC_MGMT", rowid);
    }
}

// ----------------------------------------------------
//    Add some methods to String prototype
// ----------------------------------------------------

String.prototype.trim = function () {
    return this.replace(/^\s+|\s+$/g, "");
}

String.prototype.ltrim = function () {
    return this.replace(/^\s+/, "");
}

String.prototype.rtrim = function () {
    return this.replace(/\s+$/, "");
}

// Globals
var is_chrome = navigator.userAgent.toLowerCase().indexOf('chrome') > -1;

function getFocus(eleId) {
    $('[id$="'+ eleId +'"]').focus();
};

//Text input masks

//date mask mm/dd/yyyy
//to call the function: onkeypress="return maskDate(event, this.value, this);"
function maskDate(e, str, textbox) {

    // #  #  /  #  #  /  #  #  #  #
    // 0  1  2  3  4  5  6  7  8  9

    var evt = e || window.event;
    var charCode = evt.which || evt.keyCode;

    var delim = new Array();
    delim[2] = '/';
    delim[5] = '/';

    var len = str.length;

    if (charCode >= 48 && charCode <= 57) {
        if (len == 0 && parseInt(String.fromCharCode(charCode)) > 1) {
            textbox.value = '0';
        }

        //check date -- optional
        if (arguments[2] && typeof (arguments[2]) == 'boolean') {
            if (len == 5) {
                m_month = parseInt(str.substring(0, 2), 10);
                m_day = parseInt(str.substring(3, 5), 10);

                if (m_day > 30 && (m_month == 2 || m_month == 4 || m_month == 6 || m_month == 9 || m_month == 11)) {
                    textbox.value = str.substring(0, 3) + '0' + str.substring(3, 4) + '/' + str.substring(4);
                    return true;
                }
            }
        }


        if (delim[len]) {
            textbox.value = str + delim[len];
        }
        return true;
    }

    if (charCode == 8 || charCode == 9) {
        return true;
    }
    return false;
}

function maskZipCode(e, str, textbox) {

    // #  #  #  #  #  -  #  #  #  #  
    // 0  1  2  3  4  5  6  7  8  9

    var evt = e || window.event;
    var charCode = evt.which || evt.keyCode;

    var delim = new Array();
    delim[5] = '-';

    var len = str.length;

    if (charCode >= 48 && charCode <= 57) {

        if (delim[len]) {
            textbox.value = str + delim[len];
        }
        return true;
    }

    if (charCode == 8 || charCode == 9) {
        return true;
    }
    return false;
}

//phone mask (###)###-####
//to call the function: onkeypress="return maskPhone(event, this.value, this);"
function maskPhone(e, str, textbox) {

    // (  #  #  #  )  #  #  #  -  #   #   #   #
    // 0  1  2  3  4  5  6  7  8  9  10  11  12    

    var evt = e || window.event;
    var charCode = evt.which || evt.keyCode;

    var delim = new Array();
    delim[0] = '(';
    delim[4] = ')';
    delim[8] = '-';


    if (charCode >= 48 && charCode <= 57) {
        if (delim[str.length]) {
            textbox.value = str + delim[str.length];
        }
        return true;
    }

    if (charCode == 8 || charCode == 9) {
        return true;
    }

    return false;
}

//FMP/SSN mask ##/######### -- for Patient Demographics Screen
//to call the function: onkeypress="return maskFMPSSN(event, this.value, this);"
function maskFMPSSN(e, str, textbox) {

    // #  #  /  #  #  #  #  #  #  #   #   #
    // 0  1  2  3  4  5  6  7  8  9  10  11  

    var evt = e || window.event;
    var charCode = evt.which || evt.keyCode;

    var delim = new Array();
    delim[2] = '/';

    if (charCode >= 48 && charCode <= 57) {
        if (delim[str.length]) {
            textbox.value = str + delim[str.length];
        }
        return true;
    }

    if (charCode == 8 || charCode == 9) {
        return true;
    }

    return false;
}

function maskFMPSSN2(e, str, textbox) {

    // #  #  /  #  #  #  -  #  #  -   #  #   #   #
    // 0  1  2  3  4  5  6  7  8  9  10  11  12  13  

    var evt = e || window.event;
    var charCode = evt.which || evt.keyCode;

    var delim = new Array();
    delim[2] = '/';
    delim[6] = '-';
    delim[9] = '-';

    if (charCode >= 48 && charCode <= 57) {
        if (delim[str.length]) {
            textbox.value = str + delim[str.length];
        }
        return true;
    }

    if (charCode == 8 || charCode == 9) {
        return true;
    }

    return false;
}

function maskFMPSSN3(e, str, textbox) {

    // #  #  #  -  #  #  -  #  #  #  #
    // 0  1  2  3  4  5  6  7  8  9  10 

    var evt = e || window.event;
    var charCode = evt.which || evt.keyCode;

    var delim = new Array();
    delim[3] = '-';
    delim[6] = '-';

    if (charCode >= 48 && charCode <= 57) {
        if (delim[str.length]) {
            textbox.value = str + delim[str.length];
        }
        return true;
    }

    if (charCode == 8 || charCode == 9) {
        return true;
    }

    return false;
}

//date mask mm/yyyy
//to call the function: onkeypress="return maskMonthYear(event, this.value, this);"
function maskMonthYear(e, str, textbox) {

    // #  #  /  #  #  #  #  #
    // 0  1  2  3  4  5  6  7

    var evt = e || window.event;
    var charCode = evt.which || evt.keyCode;

    var delim = new Array();
    delim[2] = '/';

    var len = str.length;

    if (charCode >= 48 && charCode <= 57) {
        if (len == 0 && parseInt(String.fromCharCode(charCode)) > 1) {
            textbox.value = '0';
        }

        if (delim[len]) {
            textbox.value = str + delim[len];
        }
        return true;
    }

    if (charCode == 8 || charCode == 9) {
        return true;
    }
    return false;
}

//date mask mm/dd
//to call the function: onkeypress="return maskMonthDay(event, this.value, this);"
function maskMonthDay(e, str, textbox) {

    // #  #  /  #  #  
    // 0  1  2  3  4  

    var evt = e || window.event;
    var charCode = evt.which || evt.keyCode;

    var delim = new Array();
    delim[2] = '/';

    var len = str.length;

    if (charCode >= 48 && charCode <= 57) {
        if (len == 0 && parseInt(String.fromCharCode(charCode)) > 1) {
            textbox.value = '0';
        }

        if (delim[len]) {
            textbox.value = str + delim[len];
        }
        return true;
    }

    if (charCode == 8 || charCode == 9) {
        return true;
    }
    return false;
}

//accept only numbers, dash, tab and spacebar
function onlyNumbers(e) {
    var evt = e || window.event;
    var charCode = evt.which || evt.keyCode;

    if (charCode >= 48 && charCode <= 57) {
        return true;
    }

    if (charCode == 8 || charCode == 9 || charCode == 45) {
        return true;
    }

    return false;
}

function checkMonthInput(e, str, textbox) {
    var evt = e || window.event;
    var charCode = evt.which || evt.keyCode;

    if (str.length == 2) {
        var m = parseInt(str);
        if (m > 12) {
            alert('Invalid month input.');
            textbox.value = '';
        }
    }
}